-- Copyright romedius (https://github.com/Rom3dius)

local Config = {
    tractionHack = true
}

-- local tractionHack = ac.OnlineEvent({
--     ac.StructItem.key("SwimTractionHack"),
--     Enabled = ac.StructItem.bool(),
--     }, function (sender, message)
--         if message.Enabled then
--             Config.tractionHack = true
--         else
--             Config.tractionHack = false
--         end
-- end)

function NumberGuard(v, alt)
    alt = alt or 0
    return (math.isNaN(v) or not v) and alt or v
end

function ZeroGuard(v)
    return 1.0 / math.max(math.min(1.0 / v, 1e15), -1e15)
end

function Sum(t, extractor)
    extractor = extractor or function(val) return val end

    if #t == 0 then
        return nil
    end

    local acc = nil
    local count = 0

    for _, tVal in ipairs(t) do
        local transformed = extractor(tVal)
        if transformed ~= nil then
            count = count + 1
            if acc == nil then
                acc = transformed
            else
                acc = acc + transformed
            end
        end
    end

    return acc, count
end

function WeightedAverage(values, weights)
    if #values ~= #weights or #values < 1 then return nil end
    local totalWeight = Sum(weights)
    if not totalWeight or totalWeight == 0 then return nil end
    local avg = values[1] * weights[1]
    for i, v in ipairs(values) do
        if i ~= 1 then
            avg = avg + v * weights[i]
        end
    end
    return avg / totalWeight
end

function script.update(dt) 
    local vehicle = ac.accessCarPhysics()

    local yawCorrectionIntensity = 800 -- This value needs tuning

    local fWheelWeights   = {ZeroGuard(vehicle.wheels[0].load), ZeroGuard(vehicle.wheels[1].load)}
    local rWheelWeights   = {ZeroGuard(vehicle.wheels[2].load), ZeroGuard(vehicle.wheels[3].load)}

    -- local fWheelInertia  = {ac.getWheelsInertia(0), ac.getWheelsInertia(1)}
    -- local rWheelInertia  = {ac.getWheelsInertia(3), ac.getWheelsInertia(4)}

    -- local travelDirection = NumberGuard(math.deg(math.atan2(storedMiddleVel.x, storedMiddleVel.z))) -- The angle of the vehicle's velocity vector on the local horizontal plane (deg), at the average position of all wheels
    local frontSlipDeg = NumberGuard(WeightedAverage({vehicle.wheels[0].slipAngle, vehicle.wheels[1].slipAngle}, fWheelWeights)) -- Average front wheel slip angle, weighted by wheel load (deg)
    local rearSlipDeg = NumberGuard(WeightedAverage({vehicle.wheels[2].slipAngle, vehicle.wheels[3].slipAngle}, rWheelWeights)) -- Average rear wheel slip angle, weighted by wheel load (deg)
    local frontNdSlip = NumberGuard(WeightedAverage({vehicle.wheels[0].ndSlip,    vehicle.wheels[1].ndSlip},    fWheelWeights)) -- Average normalized front slip, weighted by wheel load
    local rearNdSlip = NumberGuard(WeightedAverage({vehicle.wheels[2].ndSlip,    vehicle.wheels[3].ndSlip},    rWheelWeights)) -- Average normalized rear slip, weighted by wheel load

    -- -- Apply yaw correction
    -- -- Counteract oversteer by inducing negative yaw (depending on the vehicle orientation)
    -- local correctionMagnitude = (frontSlipDeg - rearSlipDeg) * yawCorrectionIntensity
    -- ac.addTorque(vec3(correctionMagnitude, 0, 0), true) -- Rear of the car
    -- ac.addTorque(vec3(-correctionMagnitude, 0, 0), true) -- Front of the car
    -- -- Counteract understeer by inducing positive yaw
    -- local correctionMagnitude = (rearSlipDeg - frontSlipDeg) * yawCorrectionIntensity
    -- ac.addTorque(vec3(-correctionMagnitude, 0, 0), true) -- Rear of the car
    -- ac.addTorque(vec3(correctionMagnitude, 0, 0), true) -- Front of the car

    -- Counteract rear spinning by adding force to the rear
    local rDownwardForce = ZeroGuard(rearNdSlip * Sum(rWheelWeights) / 10)
    -- ac.addHubForce(3, vec3(0, 0, 0), vec3(0, -rDownwardForce, 0), false, false)
    -- ac.addHubForce(4, vec3(0, 0, 0), vec3(0, -rDownwardForce, 0), false, false)
    if rDownwardForce > 0.5 then
        ac.addForce(vec3(0, 0, -3), true, vec3(0, -rDownwardForce, 0), true)
    end

    -- Debug output
    -- ac.debug('travelDirection', travelDirection)
    ac.debug('frontSlipDeg', frontSlipDeg)
    ac.debug('rearSlipDeg', rearSlipDeg)
    ac.debug('frontNdSlip', frontNdSlip)
    ac.debug('rearNdSlip', rearNdSlip)
    ac.debug('rDownwardForce', rDownwardForce)
end

    -- Car = ac.accessCarPhysics()

    -- -- Calculate average slip angle for front and rear tires
    -- local frontSlipAngleAvg = (math.abs(Car.wheels[0].slipAngle) + math.abs(Car.wheels[1].slipAngle)) / 2
    -- local rearSlipAngleAvg = (math.abs(Car.wheels[2].slipAngle) + math.abs(Car.wheels[3].slipAngle)) / 2

    -- -- Determine if the car is oversteering or understeering
    -- local oversteering = rearSlipAngleAvg > frontSlipAngleAvg
    -- local understeering = frontSlipAngleAvg > rearSlipAngleAvg

    -- local correctionFactor = 20 -- This value might need tuning
    -- local correction = (rearSlipAngleAvg - frontSlipAngleAvg) * correctionFactor * Car.speedKmh / 100

    -- -- Apply corrections
    -- if oversteering then
    --     -- Apply force to reduce oversteer by increasing rear tire grip
    --     ac.addHubForce(2, vec3(0, 0, 0), vec3(0, -correction / 2, 0), true, true)
    --     ac.addHubForce(3, vec3(0, 0, 0), vec3(0, -correction / 2, 0), true, true)
    -- elseif understeering then
    --     -- Apply force to reduce understeer by increasing front tire grip
    --     ac.addHubForce(0, vec3(0, 0, 0), vec3(0, -correction / 2, 0), true, true)
    --     ac.addHubForce(1, vec3(0, 0, 0), vec3(0, -correction / 2, 0), true, true)
    -- end

    -- -- Debug output
    -- ac.debug('FrontSlipAngleAvg', frontSlipAngleAvg)
    -- ac.debug('RearSlipAngleAvg', rearSlipAngleAvg)
    -- ac.debug('Correction', correction)

    -- Car = ac.accessCarPhysics()
    -- local rearLateralSlip = math.round(Car.wheels[2].slipRatio + Car.wheels[3].slipRatio, 3)

    -- local weight = (rearLateralSlip * Car.speedKmh) / 10

    -- Car.wheels[1].slip

    -- if rearLateralSlip > 0.1 then
    --     ac.addHubForce(2, vec3(0, 0, 0), vec3(0, -weight / 2, 0), true, true)
    --      ac.addHubForce(2, vec3(0, 0, 0), vec3(0, -weight / 2, 0), true, true)
    -- end

    -- ac.debug('RearLateral', rearLateralSlip)
    -- ac.debug('Tire 48', weight)


    -- if Config.tractionHack then
    --     local tireNum = 0
    --     for tireNum = 0, 3 do
    --         local tire = Car.wheels[tireNum]
    --         local slippage = math.abs(tire.slipRatio) + math.abs(tire.slipAngle)
    --         local weight = slipWeight * slippage
    --         ac.addHubForce(tireNum, vec3(0, 0, 0), vec3(0, -weight, 0), true, true)
    --         ac.debug('Tire ' .. tireNum, weight)
    --     end
    -- end
    -- Car = ac.getCar(0)
    -- for tireNum = 0, 3 do
    --     local tire = ac.getCarWheelSurface(tireNum)
    --     tire.grip = 20
    -- end
-- end